DROP PROCEDURE [hips].[HospitalProviderGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon
-- Create date:   16 October 2012
-- Description:   Gets one or more Hospital providers from the HospitalHealthProviderIndividual table
-- =============================================
CREATE PROCEDURE [hips].[HospitalProviderGet] 
(
	   @HospitalId INT = NULL,
	   @HospitalHealthProviderIndividualId INT = NULL
) AS
BEGIN
SELECT 
		h.HospitalId,		
		h.HealthProviderIndividualId,
		h.CisProviderIdentifier,
		h.PasProviderIdentifier,
		h.DateCreated,
		h.UserCreated,
		h.DateModified,
		h.UserModified
		
FROM       hips.HospitalHealthProviderIndividual h
WHERE (@HospitalId IS NULL  OR h.HospitalId = @HospitalId)
AND (@HospitalHealthProviderIndividualId IS NULL OR h.HealthProviderIndividualId = @HospitalHealthProviderIndividualId)

END
GO

